﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIAEMRService;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;
using System.Diagnostics;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class SendBothLoginsToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.ProUserDuz) && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.AppointmentType == AppointmentType.HOME_MOBILE && !string.IsNullOrEmpty(state.PatUserDuz))
                return;
            else if (state.AppointmentType == AppointmentType.STORE_FORWARD && !string.IsNullOrEmpty(state.ProUserDuz))
                return;

            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                if (state.ProEcRequest != null)
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.ProUserDuz) ? "FAKE_ProviderLogin" : state.ProUserDuz;
                if (state.PatEcRequest != null)
                state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = string.IsNullOrEmpty(state.PatUserDuz) ? "FAKE_PatientLogin" : state.PatUserDuz;
                return;
            }
            LoginRequest patLogin = new LoginRequest
            {
                side = Side.Patient
            };
            if (string.IsNullOrEmpty(state.PatUserDuz))
                patLogin.Request = state.PatLoginRequest;
            else
                patLogin.userId = state.PatUserDuz;


            LoginRequest proLogin = new LoginRequest
            {
                side = Side.Provider
            };

            if (string.IsNullOrEmpty(state.ProUserDuz))
                proLogin.Request = state.ProLoginRequest;
            else
                proLogin.userId = state.ProUserDuz;

            var LoginRequests = new List<LoginRequest>();
            if (state.PatEcRequest != null)
                LoginRequests.Add(patLogin);
            if (state.ProEcRequest != null)
                LoginRequests.Add(proLogin);
            var timer = new Stopwatch();
            timer.Start();
            Parallel.ForEach(new LoginRequest[] { patLogin, proLogin }, login => 
            {
                if (login.Request != null)
                    login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
            });
            timer.Stop();
            state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
            if (state.ProEcRequest != null)
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = proLogin.userId;
            if (state.PatEcRequest != null)
                state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = patLogin.userId;
        }
    }

    
}
